/*----------------------------------------------------------------------------
 * Name:    LCM.h
 * Purpose: LCM definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef __LCM_H
#define __LCM_H

#include "ht32f520xx_01.h"

#define  _LCM_RES_   7     /* PB7 */	
#define  _LCM_RS_    5     /* PB5 */
#define  _LCM_NCS_   2     /* PB2 */
#define  _LCM_SCK_   3     /* PB3 */
#define  _LCM_SDA_   4     /* PB4 */

#define	LCM_RES_LOW    HT_GPIOB->DOUTR &= ~(1UL << _LCM_RES_);	/* RES = 0 */											
#define	LCM_RES_HIGH   HT_GPIOB->DOUTR |= (1UL << _LCM_RES_);		/* RES = 1 */
#define	LCM_RS_LOW	   HT_GPIOB->DOUTR &= ~(1UL << _LCM_RS_);   	/* LCM_RS = 0 */
#define	LCM_RS_HIGH	   HT_GPIOB->DOUTR |= (1UL << _LCM_RS_);    	/* LCM_RS = 1 */

#define  LCM_SPI     	HT_SPI0																														
#define	LCM_SPI_SPEED	(5000000UL)

enum 
{
   DSP_NORMAL = 0x50,
   DSP_INVERT,
   DSP_CURSOR,
   DSP_CLEAR	
};

extern uc8 BestComm_Logo[];

void lcm_bus_configure(void);
void lcm_configure(void);
void lcm_write_cmd(u8 cmdx);
void lcm_write_data(u8 da);
void lcm_set_position(u8 row,u8 col);
void lcm_write_blcok_data(u8 leng,u8 *p,u8 invt);
void lcm_clear(void);
void lcm_put_map(u8 *p);
void lcm_put6x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x16_char(char val,u8 row,u8 col,u8 invt);
void lcm_put6x8_clearing(u8 row);
void lcm_put6x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x8_clearing(u8 row);
void lcm_put8x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x16_clearing(u8 row);
void lcm_put8x16_string(sc8 *p,u8 row,u8 col,u8 invt);

#endif
